//*******************************************************************************************************************************************
// The two methods of this class initialize the sentence corpus and reinitialize the statistical arrays for each new simulation.
//*******************************************************************************************************************************************

package ezreader10;

import java.util.*;

class Corpus {
    
    //**************************************************************************
     
    void initialize(Scanner diskScanner, ArrayList<Sentence> text, int targets[]) {
        
        double characterPosition = 0; // cumulative character position within sentence
        int sentenceN = 0; // index for sentence number
        int wordN = 0; // index for word number
        
        // Initialize Sentence class:
        Sentence s = new Sentence();
 
        // Scan next chunk from input file:
        while (diskScanner.hasNext()) {
            
            // Read word attributes:
            Word w = new Word();
            w.iv.N = wordN;
            w.iv.frequency = diskScanner.nextDouble();
            w.iv.length = diskScanner.nextInt();
            w.iv.cloze = diskScanner.nextDouble();;
            w.iv.letters = " " + diskScanner.next();
        
            // This code is used to specify the properties of target words:
            if (EZReader10.includeTargetWords == true) {
                // i.e., pre-target words
                if (wordN == targets[sentenceN] - 1) { 
                    //w.iv.freq = 1000.0;
                    //w.iv.length = 5;
                    //w.iv.cloze = 0.1;
                }   
                // i.e., target words
                if (wordN == targets[sentenceN]) { 
                    //w.iv.freq = 10.0;
                    //w.iv.length = 5;
                    //w.iv.cloze = 0.1;   
                }
            }
            
            // Calculate frequency variables:
            w.iv.log10Frequency = Math.log10(w.iv.frequency);
            w.iv.frequencyClass = (int)Math.log10(w.iv.frequency);
            
            // Calculate letter positions and OVP:
            w.iv.position0 = characterPosition;
            w.iv.position1 = characterPosition + 1.0;
            w.iv.positionN = w.iv.position1 + w.iv.length;
            w.iv.OVP = w.iv.position1 + (w.iv.length * 0.5);
            characterPosition += (w.iv.length + 1.0);
            
            // Add word to sentence:
            s.add(w);
            wordN++;

            // Identify end of sentence:
            if (w.iv.letters.charAt(w.iv.letters.length() - 1) == '@') {  
                w.iv.letters = w.iv.letters.substring(0, w.iv.letters.length() - 1);                 
                s.N = sentenceN;
                s.numberWords = wordN;
                s.target = targets[sentenceN];
                text.add(s);
                s = new Sentence();
                sentenceN++; // i.e., increment sentence number index
                wordN = 0;
                characterPosition = 0;
            } 
        }
    }
    
    //**************************************************************************
    
    void zeroWordDVs(ArrayList<Sentence> text) {
        
        for (int i = 0; i < EZReader10.NSentences; i++) {
            text.get(i).regressionN = 0;
            for (int j = 0; j < text.get(i).numberWords; j++) {
                text.get(i).get(j).dv.FFD = 0; 
                text.get(i).get(j).dv.GD = 0;
                text.get(i).get(j).dv.GoPast = 0;
                text.get(i).get(j).dv.NFirstPassFixations = 0;
                text.get(i).get(j).dv.NFixations = 0; 
                text.get(i).get(j).dv.Pr1 = 0; 
                text.get(i).get(j).dv.Pr2 = 0; 
                text.get(i).get(j).dv.PrF = 0;  
                text.get(i).get(j).dv.PrS = 0; 
                text.get(i).get(j).dv.SFD = 0; 
                text.get(i).get(j).dv.TT = 0; 
            }
        }
    }
}

//*******************************************************************************************************************************************

